/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.interpreter.BinaryFieldInterpreter;
import cds.savot.model.interpreter.BinaryInterpreterException;

public class LongInterpreter
extends BinaryFieldInterpreter<Long> {
    public LongInterpreter() throws BinaryInterpreterException {
        this(new int[]{1});
    }

    public LongInterpreter(int[] arraysizes) throws BinaryInterpreterException {
        super(arraysizes, "long value", 8);
    }

    @Override
    public Long decodePrimary(byte[] b, int offset) throws BinaryInterpreterException {
        return ((long)b[offset] & 0xFFL) << 56 | ((long)b[offset + 1] & 0xFFL) << 48 | ((long)b[offset + 2] & 0xFFL) << 40 | ((long)b[offset + 3] & 0xFFL) << 32 | ((long)b[offset + 4] & 0xFFL) << 24 | ((long)b[offset + 5] & 0xFFL) << 16 | ((long)b[offset + 6] & 0xFFL) << 8 | ((long)b[offset + 7] & 0xFFL) << 0;
    }

    @Override
    protected Class<Long[]> getArrayClass() {
        return Long[].class;
    }

    @Override
    protected Long convertPrimary(Object value) throws BinaryInterpreterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException nfe) {
                throw new BinaryInterpreterException("Impossible to convert \"" + value + "\" into a Long: " + nfe.getMessage() + " !");
            }
        }
        throw new BinaryInterpreterException("Impossible to convert a " + value.getClass().getName() + " into a Long !");
    }

    @Override
    public byte[] encodePrimary(Long value) throws BinaryInterpreterException {
        if (value == null) {
            return new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        }
        byte[] encoded = new byte[8];
        int i = 0;
        while (i < encoded.length) {
            encoded[i] = (byte)(value >>> 8 * (encoded.length - 1 - i));
            ++i;
        }
        return encoded;
    }
}

