/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.interpreter.BinaryFieldInterpreter;
import cds.savot.model.interpreter.BinaryInterpreterException;

public class ShortInterpreter
extends BinaryFieldInterpreter<Short> {
    public ShortInterpreter(int[] arraysizes) throws BinaryInterpreterException {
        super(arraysizes, "short value", 2);
    }

    @Override
    public Short decodePrimary(byte[] b, int offset) throws BinaryInterpreterException {
        return (short)(b[offset] << 8 | b[offset + 1] & 0xFF);
    }

    @Override
    protected Class<Short[]> getArrayClass() {
        return Short[].class;
    }

    @Override
    protected Short convertPrimary(Object value) throws BinaryInterpreterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            try {
                return Short.parseShort((String)value);
            }
            catch (NumberFormatException nfe) {
                throw new BinaryInterpreterException("Impossible to convert \"" + value + "\" into a Short: " + nfe.getMessage() + " !");
            }
        }
        throw new BinaryInterpreterException("Impossible to convert a " + value.getClass().getName() + " into a Short !");
    }

    @Override
    public byte[] encodePrimary(Short value) throws BinaryInterpreterException {
        if (value == null) {
            return new byte[]{-1, -1};
        }
        byte[] encoded = new byte[]{(byte)(value >> 8), (byte)(value & 0xFF)};
        return encoded;
    }
}

