/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.interpreter.BinaryInterpreterException;
import cds.savot.model.interpreter.CharInterpreter;

public class UnicodeCharInterpreter
extends CharInterpreter {
    public UnicodeCharInterpreter(int[] arraysizes) throws BinaryInterpreterException {
        super(arraysizes, "unicode character", 2);
    }

    @Override
    public Character decodePrimary(byte[] b, int offset) throws BinaryInterpreterException {
        return Character.valueOf((char)(b[offset] << 8 | b[offset + 1] & 0xFF));
    }

    @Override
    public byte[] encodePrimary(Character value) throws BinaryInterpreterException {
        if (value == null) {
            return this.getPadding();
        }
        return new byte[]{(byte)(value.charValue() >> 8), (byte)(value.charValue() & 0xFF)};
    }
}

