/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.writer;

import cds.savot.model.CoosysSet;
import cds.savot.model.FieldRefSet;
import cds.savot.model.FieldSet;
import cds.savot.model.GroupSet;
import cds.savot.model.InfoSet;
import cds.savot.model.LinkSet;
import cds.savot.model.OptionSet;
import cds.savot.model.ParamRefSet;
import cds.savot.model.ParamSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotBinary;
import cds.savot.model.SavotCoosys;
import cds.savot.model.SavotData;
import cds.savot.model.SavotField;
import cds.savot.model.SavotFieldRef;
import cds.savot.model.SavotFits;
import cds.savot.model.SavotGroup;
import cds.savot.model.SavotInfo;
import cds.savot.model.SavotLink;
import cds.savot.model.SavotMax;
import cds.savot.model.SavotMin;
import cds.savot.model.SavotOption;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotParamRef;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotStream;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotTableData;
import cds.savot.model.SavotVOTable;
import cds.savot.model.SavotValues;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.model.TableSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class SavotWriter {
    private static String top1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static String top2 = "\n<VOTABLE xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:noNamespaceSchemaLocation=\"xmlns:http://www.ivoa..net/xml/VOTable-1.1.xsd\" version=";
    private static boolean attributeEntities = true;
    private static boolean elementEntities = true;
    private static OutputStream outStream = null;
    private static BufferedWriter dataBuffWriter = null;
    private static final String tdbegin1 = "<TD";
    private static final String tdbegin2 = ">";
    private static final String tdend = "</TD>";
    private static final String trbegin = "<TR>";
    private static final String trend = "</TR>\n";
    private static final String commentbegin = "<!-- ";
    private static final String commentend = " -->\n";
    private static final String tabledatabegin = "\n<TABLEDATA>\n";
    private static final String tabledataend = "</TABLEDATA>";
    private static final String databegin = "\n<DATA>";
    private static final String dataend = "\n</DATA>";
    private static final String tablebegin = "\n<TABLE>";
    private static final String tableend = "\n</TABLE>";
    private static final String resourcebegin = "\n<RESOURCE>";
    private static final String resourceend = "\n</RESOURCE>";
    private static final String infobegin = "<INFO>\n";
    private static final String infoend = "</INFO>\n";
    private static final String descriptionbegin = "\n<DESCRIPTION>";
    private static final String descriptionend = "</DESCRIPTION>";
    private static final String groupbegin = "\n<GROUP>";
    private static final String groupend = "\n</GROUP>";
    private static final String definitionsbegin = "\n<DEFINITIONS>";
    private static final String definitionsend = "\n</DEFINITIONS>";
    private static final String parambegin = "\n<PARAM>";
    private static final String paramend = "\n</PARAM>";
    private static final String fieldbegin = "\n<FIELD>";
    private static final String fieldend = "\n</FIELD>";
    private static final String linkbegin = "\n<LINK>";
    private static final String linkend = "</LINK>";
    private static final String valuesbegin = "\n<VALUES>";
    private static final String valuesend = "\n</VALUES>";
    private static final String fitsbegin = "\n<FITS>";
    private static final String fitsend = "\n</FITS>";
    private static final String binarybegin = "\n<BINARY>";
    private static final String binaryend = "\n</BINARY>";
    private static final String coosysbegin = "\n<COOSYS>";
    private static final String coosysend = "</COOSYS>";
    private static final String streambegin = "\n<STREAM>";
    private static final String streamend = "\n</STREAM>";
    private static final String minbegin = "\n<MIN>";
    private static final String minend = "</MIN>";
    private static final String maxbegin = "\n<MAX>";
    private static final String maxend = "</MAX>";
    private static final String optionbegin = "\n<OPTION>";
    private static final String optionend = "\n</OPTION>";

    public void enableAttributeEntities(boolean entities) {
        attributeEntities = entities;
    }

    public void enableElementEntities(boolean entities) {
        elementEntities = entities;
    }

    public void enableEntities(boolean entities) {
        attributeEntities = entities;
        elementEntities = entities;
    }

    private static String replace(String src, String oldPattern, String newPattern) {
        String dst = "";
        int last = 0;
        boolean done = false;
        while (!done) {
            int i = src.indexOf(oldPattern, last);
            if (i == -1) {
                done = true;
                if (last >= src.length()) continue;
                dst = dst.concat(src.substring(last, src.length()));
                continue;
            }
            if (i != last) {
                dst = dst.concat(src.substring(last, i));
            }
            last = i + oldPattern.length();
            dst = dst.concat(newPattern);
        }
        return dst;
    }

    public static String encodeAttribute(String src) {
        if (attributeEntities) {
            src = SavotWriter.replace(src, "&", "&amp;");
            src = SavotWriter.replace(src, "\"", "&quot;");
            src = SavotWriter.replace(src, "<", "&lt;");
            src = SavotWriter.replace(src, tdbegin2, "&gt;");
        }
        return src;
    }

    public static String encodeElement(String src) {
        if (elementEntities) {
            src = SavotWriter.replace(src, "&", "&amp;");
            src = SavotWriter.replace(src, "\"", "&quot;");
            src = SavotWriter.replace(src, "<", "&lt;");
            src = SavotWriter.replace(src, tdbegin2, "&gt;");
        }
        return src;
    }

    public void generateDocument(SavotVOTable votable) throws IOException {
        this.generateDocument(votable, null, null);
    }

    public void generateDocument(SavotVOTable votable, OutputStream stream) throws IOException {
        this.generateDocument(votable, null, stream);
    }

    public void generateDocument(SavotVOTable votable, String file) throws IOException {
        this.generateDocument(votable, file, null);
    }

    public void generateDocument(SavotVOTable votable, String file, OutputStream stream) throws IOException {
        if (file == null) {
            outStream = stream == null ? System.out : stream;
            dataBuffWriter = new BufferedWriter(new OutputStreamWriter(outStream));
        } else {
            outStream = new FileOutputStream(new File(file));
            dataBuffWriter = new BufferedWriter(new OutputStreamWriter(outStream));
        }
        dataBuffWriter.write(top1);
        if (votable.getAbove() != "") {
            String comment = commentbegin + votable.getAbove() + " -->";
            dataBuffWriter.write(comment);
        }
        StringBuffer buftop2 = new StringBuffer();
        if (votable.getXmlns().compareTo("") != 0 || votable.getXmlnsxsi().compareTo("") != 0 || votable.getXsischema().compareTo("") != 0 || votable.getXmlns().compareTo("") != 0) {
            buftop2.append("\n<VOTABLE");
            if (votable.getXmlns().compareTo("") != 0) {
                buftop2.append(" xmlns=").append('\"').append(votable.getXmlns()).append('\"');
            }
            if (votable.getXmlnsxsi().compareTo("") != 0) {
                buftop2.append(" xmlns:xsi=").append('\"').append(votable.getXmlnsxsi()).append('\"');
            }
            if (votable.getXsischema().compareTo("") != 0) {
                buftop2.append(" xsi:schemaLocation=").append('\"').append(votable.getXsischema()).append('\"');
            }
            if (votable.getXsinoschema().compareTo("") != 0) {
                buftop2.append(" xsi:noNamespaceSchemaLocation=").append('\"').append(votable.getXsinoschema()).append('\"');
            }
            buftop2.append(" version=");
        }
        if (votable.getVersion().compareTo("") != 0) {
            buftop2.append('\"').append(votable.getVersion()).append('\"');
            if (votable.getId().compareTo("") != 0) {
                buftop2.append(" ID=\"").append(votable.getId()).append('\"');
            }
            buftop2.append('>');
        } else {
            buftop2.append("\"1.1\"");
            if (votable.getId().compareTo("") != 0) {
                buftop2.append(" ID=\"").append(votable.getId()).append('\"');
            }
            buftop2.append('>');
        }
        dataBuffWriter.write(buftop2.toString());
        if (votable.getBelow() != "") {
            String comment = commentbegin + votable.getBelow() + " -->";
            dataBuffWriter.write(comment);
        }
        if (votable.getDescription() != null) {
            StringBuffer description = new StringBuffer();
            if (votable.getDescription() != null && !votable.getDescription().equals("")) {
                if (votable.getAbove() != "") {
                    description.append("\n<!-- ").append(votable.getAbove()).append(" -->");
                }
                description.append(descriptionbegin);
                if (votable.getBelow() != "") {
                    description.append("\n<!-- ").append(votable.getBelow()).append(commentend);
                }
                description.append(SavotWriter.encodeElement(votable.getDescription())).append(descriptionend);
                dataBuffWriter.write(description.toString());
            }
        }
        if (votable.getDefinitions() != null) {
            dataBuffWriter.write(definitionsbegin);
            CoosysSet coosysSet = votable.getDefinitions().getCoosys();
            this.writeCoosys(coosysSet);
            ParamSet paramSet = votable.getDefinitions().getParams();
            this.writeParam(paramSet);
            dataBuffWriter.write(definitionsend);
        }
        CoosysSet coosyset = votable.getCoosys();
        this.writeCoosys(coosyset);
        ParamSet paramset = votable.getParams();
        this.writeParam(paramset);
        InfoSet infoset = votable.getInfos();
        this.writeInfo(infoset);
        ResourceSet resourceset = votable.getResources();
        this.writeResource(resourceset);
        dataBuffWriter.write("\n</VOTABLE>\n");
        dataBuffWriter.flush();
    }

    public void writeDescription(String description) throws IOException {
        dataBuffWriter.write("<DESCRIPTION>" + SavotWriter.encodeElement(description) + descriptionend);
        dataBuffWriter.flush();
    }

    public void initStream(String file) throws IOException {
        outStream = new FileOutputStream(new File(file));
        dataBuffWriter = new BufferedWriter(new OutputStreamWriter(outStream));
    }

    public void initStream(OutputStream stream) throws IOException {
        outStream = stream == null ? System.out : stream;
        dataBuffWriter = new BufferedWriter(new OutputStreamWriter(outStream));
    }

    public void writeComment(String comment) throws IOException {
        dataBuffWriter.write("<!--" + comment + "-->");
    }

    public void writeDocumentHead(SavotVOTable votable) throws IOException {
        String version;
        dataBuffWriter.write(top1);
        StringBuffer top2buf = new StringBuffer();
        if (votable.getXmlns().compareTo("") != 0 || votable.getXmlnsxsi().compareTo("") != 0 || votable.getXsischema().compareTo("") != 0 || votable.getXmlns().compareTo("") != 0) {
            top2buf.append("\n<VOTABLE");
            if (votable.getXmlns().compareTo("") != 0) {
                top2buf.append(" xmlns=\"").append(votable.getXmlns()).append('\"');
            }
            if (votable.getXmlnsxsi().compareTo("") != 0) {
                top2buf.append(" xmlns:xsi=\"").append(votable.getXmlnsxsi()).append('\"');
            }
            if (votable.getXsischema().compareTo("") != 0) {
                top2buf.append(" xsi:schemaLocation=\"").append(votable.getXsischema()).append('\"');
            }
            if (votable.getXsinoschema().compareTo("") != 0) {
                top2buf.append(" xsi:noNamespaceSchemaLocation=\"").append(votable.getXsinoschema()).append('\"');
            }
            top2buf.append(" version=\"");
        }
        if ((version = votable.getVersion()).compareTo("") == 0) {
            version = "1.1";
        }
        top2buf.append(version).append('\"');
        String ID = votable.getId();
        if (ID.compareTo("") != 0) {
            top2buf.append(" ID=\"").append(ID).append('\"');
        }
        top2buf.append('>');
        dataBuffWriter.write(top2buf.toString());
        if (votable.getDefinitions() != null) {
            dataBuffWriter.write(definitionsbegin);
            CoosysSet coosysSet = votable.getDefinitions().getCoosys();
            this.writeCoosys(coosysSet);
            ParamSet paramSet = votable.getDefinitions().getParams();
            this.writeParam(paramSet);
            dataBuffWriter.write(definitionsend);
        }
        dataBuffWriter.flush();
    }

    public void writeDocumentEnd() throws IOException {
        dataBuffWriter.write("\n</VOTABLE>\n");
        dataBuffWriter.flush();
    }

    public void writeCoosys(CoosysSet coosysSet) throws IOException {
        int i = 0;
        while (i < coosysSet.getItemCount()) {
            StringBuffer coosysline = new StringBuffer();
            SavotCoosys coosys = (SavotCoosys)coosysSet.getItemAt(i);
            if (coosys.getAbove() != "") {
                coosysline.append("\n<!-- ").append(coosys.getAbove()).append(" -->");
            }
            coosysline.append("\n<COOSYS");
            if (coosys.getId() != null && !coosys.getId().equals("")) {
                coosysline.append(" ID=\"").append(coosys.getId()).append('\"');
            }
            if (coosys.getEquinox() != null && !coosys.getEquinox().equals("")) {
                coosysline.append(" equinox=\"").append(coosys.getEquinox()).append('\"');
            }
            if (coosys.getEpoch() != null && !coosys.getEpoch().equals("")) {
                coosysline.append(" epoch=\"").append(coosys.getEpoch()).append('\"');
            }
            if (coosys.getSystem() != null && !coosys.getSystem().equals("")) {
                coosysline.append(" system=\"").append(coosys.getSystem()).append('\"');
            }
            if (coosys.getContent() != null && !coosys.getContent().equals("")) {
                coosysline.append('>');
                if (coosys.getBelow() != "") {
                    coosysline.append("\n<!-- ").append(coosys.getBelow()).append(commentend);
                }
                coosysline.append(coosys.getContent());
                dataBuffWriter.write(coosysline.toString());
                dataBuffWriter.write(coosysend);
            } else {
                coosysline.append("/>");
                if (coosys.getBelow() != "") {
                    coosysline.append("\n<!-- ").append(coosys.getBelow()).append(commentend);
                }
                dataBuffWriter.write(coosysline.toString());
            }
            ++i;
        }
    }

    public void writeParam(ParamSet params) throws IOException {
        if (params == null) {
            return;
        }
        int i = 0;
        while (i < params.getItemCount()) {
            StringBuffer paramline = new StringBuffer();
            SavotParam param = (SavotParam)params.getItemAt(i);
            if (param.getAbove() != "") {
                paramline.append("\n<!-- ").append(param.getAbove()).append(" -->");
            }
            paramline.append("\n<PARAM");
            if (param.getId() != null && !param.getId().equals("")) {
                paramline.append(" ID=\"").append(SavotWriter.encodeAttribute(param.getId())).append('\"');
            }
            if (param.getUnit() != null && !param.getUnit().equals("")) {
                paramline.append(" unit=").append('\"').append(SavotWriter.encodeAttribute(param.getUnit())).append('\"');
            }
            if (param.getDataType() != null && !param.getDataType().equals("")) {
                paramline.append(" datatype=").append('\"').append(SavotWriter.encodeAttribute(param.getDataType())).append('\"');
            }
            if (param.getPrecision() != null && !param.getPrecision().equals("")) {
                paramline.append(" precision=").append('\"').append(SavotWriter.encodeAttribute(param.getPrecision())).append('\"');
            }
            if (param.getWidth() != null && !param.getWidth().equals("")) {
                paramline.append(" width=").append('\"').append(SavotWriter.encodeAttribute(param.getWidth())).append('\"');
            }
            if (param.getRef() != null && !param.getRef().equals("")) {
                paramline.append(" ref=").append('\"').append(SavotWriter.encodeAttribute(param.getRef())).append('\"');
            }
            if (param.getName() != null && !param.getName().equals("")) {
                paramline.append(" name=").append('\"').append(SavotWriter.encodeAttribute(param.getName())).append('\"');
            }
            if (param.getUcd() != null && !param.getUcd().equals("")) {
                paramline = paramline.append(" ucd=").append('\"').append(SavotWriter.encodeAttribute(param.getUcd())).append('\"');
            }
            if (param.getUtype() != null && !param.getUtype().equals("")) {
                paramline.append(" utype=").append('\"').append(SavotWriter.encodeAttribute(param.getUtype())).append('\"');
            }
            if (param.getValue() != null && !param.getValue().equals("")) {
                paramline.append(" value=").append('\"').append(SavotWriter.encodeAttribute(param.getValue())).append('\"');
            }
            if (param.getArraySize() != null && !param.getArraySize().equals("")) {
                paramline.append(" arraysize=").append('\"').append(SavotWriter.encodeAttribute(param.getArraySize())).append('\"');
            }
            if (param.getValues() != null || param.getLinks().getItemCount() != 0 || param.getDescription() != null && !param.getDescription().equals("")) {
                paramline.append('>');
                if (param.getBelow() != "") {
                    paramline.append("\n<!-- ").append(param.getBelow()).append(commentend);
                }
                if (param.getDescription() != null && !param.getDescription().equals("")) {
                    paramline.append(descriptionbegin).append(param.getDescription()).append(descriptionend);
                }
                dataBuffWriter.write(paramline.toString());
                this.writeValues(param.getValues());
                this.writeLink(param.getLinks());
                dataBuffWriter.write(paramend);
            } else {
                paramline.append("/>");
                if (param.getBelow() != "") {
                    paramline.append("\n<!-- ").append(param.getBelow()).append(commentend);
                }
                dataBuffWriter.write(paramline.toString());
            }
            ++i;
        }
    }

    public void writeParamRef(ParamRefSet refparams) throws IOException {
        if (refparams == null) {
            return;
        }
        int i = 0;
        while (i < refparams.getItemCount()) {
            StringBuffer paramline = new StringBuffer();
            SavotParamRef paramref = (SavotParamRef)refparams.getItemAt(i);
            if (paramref.getAbove() != "") {
                paramline.append("\n<!-- ").append(paramref.getAbove()).append(" -->");
            }
            paramline.append("\n<PARAMref");
            if (paramref.getRef() != null && !paramref.getRef().equals("")) {
                paramline.append(" ref=").append('\"').append(SavotWriter.encodeAttribute(paramref.getRef())).append('\"');
            }
            paramline.append("/>");
            if (paramref.getBelow() != "") {
                paramline.append("\n<!-- ").append(paramref.getBelow()).append(commentend);
            }
            dataBuffWriter.write(paramline.toString());
            dataBuffWriter.write(paramend);
            ++i;
        }
    }

    public void writeLink(LinkSet linkSet) throws IOException {
        int k = 0;
        while (k < linkSet.getItemCount()) {
            StringBuffer linkline = new StringBuffer();
            SavotLink link = (SavotLink)linkSet.getItemAt(k);
            if (((SavotLink)linkSet.getItemAt(k)).getAbove() != "") {
                linkline.append("\n<!-- ").append(((SavotLink)linkSet.getItemAt(k)).getAbove()).append(" -->");
            }
            linkline.append("\n<LINK");
            if (link.getID() != null && !link.getID().equals("")) {
                linkline.append(" ID=").append('\"').append(SavotWriter.encodeAttribute(link.getID())).append('\"');
            }
            if (link.getContentRole() != null && !link.getContentRole().equals("")) {
                linkline.append(" content-role=").append('\"').append(SavotWriter.encodeAttribute(link.getContentRole())).append('\"');
            }
            if (link.getContentType() != null && !link.getContentType().equals("")) {
                linkline.append(" content-type=").append('\"').append(SavotWriter.encodeAttribute(link.getContentType())).append('\"');
            }
            if (link.getTitle() != null && !link.getTitle().equals("")) {
                linkline.append(" title=").append('\"').append(SavotWriter.encodeAttribute(link.getTitle())).append('\"');
            }
            if (link.getValue() != null && !link.getValue().equals("")) {
                linkline.append(" value=").append('\"').append(SavotWriter.encodeAttribute(link.getValue())).append('\"');
            }
            if (link.getHref() != null && !link.getHref().equals("")) {
                linkline.append(" href=").append('\"').append(SavotWriter.encodeAttribute(link.getHref())).append('\"');
            }
            if (link.getGref() != null && !link.getGref().equals("")) {
                linkline.append(" gref=").append('\"').append(SavotWriter.encodeAttribute(link.getGref())).append('\"');
            }
            if (link.getAction() != null && !link.getAction().equals("")) {
                linkline.append(" action=").append('\"').append(SavotWriter.encodeAttribute(link.getAction())).append('\"');
            }
            if (link.getContent() != null && !link.getContent().equals("")) {
                linkline.append('>');
                if (link.getBelow() != "") {
                    linkline.append("\n<!-- ").append(link.getBelow()).append(commentend);
                }
                linkline.append(link.getContent());
                dataBuffWriter.write(linkline.toString());
                dataBuffWriter.write(linkend);
            } else {
                linkline.append("/>");
                if (link.getBelow() != "") {
                    linkline.append("\n<!-- ").append(link.getBelow()).append(commentend);
                }
                dataBuffWriter.write(linkline.toString());
            }
            ++k;
        }
    }

    public void writeInfo(InfoSet infoSet) throws IOException {
        if (infoSet != null) {
            int infocount = infoSet.getItemCount();
            int j = 0;
            while (j < infocount) {
                StringBuffer info = new StringBuffer();
                if (((SavotInfo)infoSet.getItemAt(j)).getAbove() != "") {
                    info.append("\n<!-- ").append(((SavotInfo)infoSet.getItemAt(j)).getAbove()).append(" -->");
                }
                info.append("\n<INFO");
                if (!((SavotInfo)infoSet.getItemAt(j)).getId().equals("")) {
                    info.append(" ID=").append('\"').append(SavotWriter.encodeAttribute(((SavotInfo)infoSet.getItemAt(j)).getId())).append('\"');
                }
                if (!((SavotInfo)infoSet.getItemAt(j)).getName().equals("")) {
                    info.append(" name=").append('\"').append(SavotWriter.encodeAttribute(((SavotInfo)infoSet.getItemAt(j)).getName())).append('\"');
                }
                if (!((SavotInfo)infoSet.getItemAt(j)).getValue().equals("")) {
                    info.append(" value=").append('\"').append(SavotWriter.encodeAttribute(((SavotInfo)infoSet.getItemAt(j)).getValue())).append('\"');
                }
                if (((SavotInfo)infoSet.getItemAt(j)).getBelow() != "") {
                    info.append("\n<!-- ").append(((SavotInfo)infoSet.getItemAt(j)).getBelow()).append(commentend);
                }
                if (((SavotInfo)infoSet.getItemAt(j)).getContent() != null && ((SavotInfo)infoSet.getItemAt(j)).getContent().compareTo("") != 0) {
                    info.append(tdbegin2).append(((SavotInfo)infoSet.getItemAt(j)).getContent()).append("</INFO>");
                } else {
                    info.append("/>");
                }
                dataBuffWriter.write(info.toString());
                ++j;
            }
        }
    }

    public void writeField(FieldSet fieldSet) throws IOException {
        int m = 0;
        while (m < fieldSet.getItemCount()) {
            SavotField field = (SavotField)fieldSet.getItemAt(m);
            StringBuffer fieldline = new StringBuffer();
            if (field.getAbove() != "") {
                fieldline.append("\n<!-- ").append(field.getAbove()).append(" -->");
            }
            fieldline.append("\n<FIELD");
            if (field.getId() != null && !field.getId().equals("")) {
                fieldline.append(" ID=").append('\"').append(SavotWriter.encodeAttribute(field.getId())).append('\"');
            }
            if (field.getName() != null && !field.getName().equals("")) {
                fieldline.append(" name=").append('\"').append(SavotWriter.encodeAttribute(field.getName())).append('\"');
            }
            if (field.getDataType() != null && !field.getDataType().equals("")) {
                fieldline.append(" datatype=").append('\"').append(SavotWriter.encodeAttribute(field.getDataType())).append('\"');
            }
            if (field.getPrecision() != null && !field.getPrecision().equals("")) {
                fieldline.append(" precision=").append('\"').append(SavotWriter.encodeAttribute(field.getPrecision())).append('\"');
            }
            if (field.getWidth() != null && !field.getWidth().equals("")) {
                fieldline.append(" width=").append('\"').append(SavotWriter.encodeAttribute(field.getWidth())).append('\"');
            }
            if (field.getRef() != null && !field.getRef().equals("")) {
                fieldline.append(" ref=").append('\"').append(SavotWriter.encodeAttribute(field.getRef())).append('\"');
            }
            if (field.getUcd() != null && !field.getUcd().equals("")) {
                fieldline.append(" ucd=").append('\"').append(SavotWriter.encodeAttribute(field.getUcd())).append('\"');
            }
            if (field.getUtype() != null && !field.getUtype().equals("")) {
                fieldline.append(" utype=").append('\"').append(SavotWriter.encodeAttribute(field.getUtype())).append('\"');
            }
            if (field.getArraySize() != null && !field.getArraySize().equals("")) {
                fieldline.append(" arraysize=").append('\"').append(SavotWriter.encodeAttribute(field.getArraySize())).append('\"');
            }
            if (field.getType() != null && !field.getType().equals("")) {
                fieldline.append(" type=").append('\"').append(SavotWriter.encodeAttribute(field.getType())).append('\"');
            }
            if (field.getUnit() != null && !field.getUnit().equals("")) {
                fieldline.append(" unit=").append('\"').append(SavotWriter.encodeAttribute(field.getUnit())).append('\"');
            }
            if (field.getDescription() != null && !field.getDescription().equals("") || field.getValues() != null || field.getLinks().getItemCount() != 0) {
                fieldline.append('>');
                if (field.getBelow() != "") {
                    fieldline.append("\n<!-- ").append(field.getBelow()).append(commentend);
                }
                if (field.getDescription() != null && !field.getDescription().equals("")) {
                    if (field.getAbove() != "") {
                        fieldline.append("\n<!-- ").append(field.getAbove()).append(" -->");
                    }
                    fieldline.append(descriptionbegin);
                    if (field.getBelow() != "") {
                        fieldline.append("\n").append(commentbegin).append(field.getBelow()).append(" -->").append("\n");
                    }
                    fieldline.append(SavotWriter.encodeElement(field.getDescription())).append(descriptionend);
                }
                dataBuffWriter.write(fieldline.toString());
                if (field.getValues() != null) {
                    this.writeValues(field.getValues());
                }
                if (field.getLinks().getItemCount() != 0) {
                    LinkSet links = field.getLinks();
                    this.writeLink(links);
                }
                dataBuffWriter.write(fieldend);
            } else {
                fieldline.append("/>");
                dataBuffWriter.write(fieldline.toString());
            }
            ++m;
        }
    }

    public void writeFieldRef(FieldRefSet fieldRefSet) throws IOException {
        int m = 0;
        while (m < fieldRefSet.getItemCount()) {
            SavotFieldRef fieldref = (SavotFieldRef)fieldRefSet.getItemAt(m);
            StringBuffer fieldline = new StringBuffer();
            if (fieldref.getAbove() != "") {
                fieldline.append("\n<!-- ").append(fieldref.getAbove()).append(" -->");
            }
            fieldline.append("\n<FIELDref");
            if (fieldref.getRef() != null && !fieldref.getRef().equals("")) {
                fieldline.append(" ref=").append(String.valueOf('\"') + SavotWriter.encodeAttribute(fieldref.getRef())).append('\"');
            }
            fieldline.append("/>");
            dataBuffWriter.write(fieldline.toString());
            ++m;
        }
    }

    public void writeStream(SavotStream stream) throws IOException {
        StringBuffer streamline = new StringBuffer();
        if (stream.getAbove() != "") {
            streamline.append("\n<!-- ").append(stream.getAbove()).append(" -->");
        }
        streamline.append("\n<STREAM");
        if (stream.getType() != null && !stream.getType().equals("")) {
            streamline.append(" type=").append('\"').append(SavotWriter.encodeAttribute(stream.getType())).append('\"');
        }
        if (stream.getHref() != null && !stream.getHref().equals("")) {
            streamline.append(" href=").append('\"').append(SavotWriter.encodeAttribute(stream.getHref())).append('\"');
        }
        if (stream.getActuate() != null && !stream.getActuate().equals("")) {
            streamline.append(" actuate=").append('\"').append(SavotWriter.encodeAttribute(stream.getActuate())).append('\"');
        }
        if (stream.getEncoding() != null && !stream.getEncoding().equals("")) {
            streamline.append(" encoding=").append('\"').append(SavotWriter.encodeAttribute(stream.getEncoding())).append('\"');
        }
        if (stream.getExpires() != null && !stream.getExpires().equals("")) {
            streamline.append(" expires=").append('\"').append(SavotWriter.encodeAttribute(stream.getExpires())).append('\"');
        }
        if (stream.getRights() != null && !stream.getRights().equals("")) {
            streamline.append(" rights=").append('\"').append(SavotWriter.encodeAttribute(stream.getRights())).append('\"');
        }
        streamline.append('>');
        if (stream.getBelow() != "") {
            streamline.append("\n<!-- ").append(stream.getBelow()).append(commentend);
        }
        dataBuffWriter.write(streamline.toString());
        if (stream.getContent() != null && !stream.getContent().equals("")) {
            dataBuffWriter.write(stream.getContent());
        }
        dataBuffWriter.write(streamend);
    }

    public void writeBinary(SavotBinary binary) throws IOException {
        StringBuffer binaryline = new StringBuffer();
        if (binary.getStream() != null) {
            if (binary.getAbove() != "") {
                binaryline.append(commentbegin).append(binary.getAbove()).append(" -->");
                dataBuffWriter.write(binaryline.toString());
            }
            dataBuffWriter.write(binarybegin);
            if (binary.getBelow() != "") {
                binaryline.append(commentbegin).append(binary.getBelow()).append(" -->");
                dataBuffWriter.write(binaryline.toString());
            }
            this.writeStream(binary.getStream());
            dataBuffWriter.write(binaryend);
        }
    }

    public void writeValues(SavotValues values) throws IOException {
        if (values == null) {
            return;
        }
        StringBuffer valuesline = new StringBuffer();
        if (values.getAbove() != "") {
            valuesline.append("\n<!-- ").append(values.getAbove()).append(" -->");
        }
        valuesline.append("\n<VALUES");
        if (values.getId() != null && !values.getId().equals("")) {
            valuesline.append(" ID=").append('\"').append(SavotWriter.encodeAttribute(values.getId())).append('\"');
        }
        if (values.getType() != null && !values.getType().equals("")) {
            valuesline.append(" type=").append('\"').append(SavotWriter.encodeAttribute(values.getType())).append('\"');
        }
        if (values.getNull() != null && !values.getNull().equals("")) {
            valuesline.append(" null=").append('\"').append(SavotWriter.encodeAttribute(values.getNull())).append('\"');
        }
        if (values.getRef() != null && !values.getRef().equals("")) {
            valuesline.append(" ref=").append('\"').append(SavotWriter.encodeAttribute(values.getRef())).append('\"');
        }
        if (values.getInvalid() != null && !values.getInvalid().equals("")) {
            valuesline.append(" invalid=").append('\"').append(SavotWriter.encodeAttribute(values.getInvalid())).append('\"');
        }
        valuesline.append('>');
        if (values.getBelow() != "") {
            valuesline.append("\n<!-- ").append(values.getBelow()).append(commentend);
        }
        dataBuffWriter.write(valuesline.toString());
        if (values.getMin() != null) {
            SavotMin min = values.getMin();
            this.writeMin(min);
        }
        if (values.getMax() != null) {
            SavotMax max = values.getMax();
            this.writeMax(max);
        }
        if (values.getOptions() != null) {
            OptionSet options = values.getOptions();
            this.writeOption(options);
        }
        dataBuffWriter.write(valuesend);
    }

    public void writeFits(SavotFits fits) throws IOException {
        StringBuffer fitsline = new StringBuffer();
        if (fits.getAbove() != "") {
            fitsline.append("\n<!-- ").append(fits.getAbove()).append(" -->");
        }
        fitsline.append("\n<FITS");
        if (fits.getExtnum() != null && !fits.getExtnum().equals("")) {
            fitsline.append(" extnum=").append('\"').append(SavotWriter.encodeAttribute(fits.getExtnum())).append('\"');
        }
        fitsline.append('>');
        if (fits.getBelow() != "") {
            fitsline.append("\n<!-- ").append(fits.getBelow()).append(commentend);
        }
        dataBuffWriter.write(fitsline.toString());
        if (fits.getStream() != null) {
            SavotStream stream = fits.getStream();
            this.writeStream(stream);
        }
        dataBuffWriter.write(fitsend);
    }

    public void writeMin(SavotMin min) throws IOException {
        StringBuffer minline = new StringBuffer();
        if (min.getAbove() != "") {
            minline.append("\n<!-- ").append(min.getAbove()).append(" -->");
        }
        minline.append("\n<MIN");
        if (min.getValue() != null && !min.getValue().equals("")) {
            minline.append(" value=").append('\"').append(SavotWriter.encodeAttribute(min.getValue())).append('\"');
        }
        if (min.getInclusive() != null && !min.getInclusive().equals("")) {
            minline.append(" inclusive=").append('\"').append(SavotWriter.encodeAttribute(min.getInclusive())).append('\"');
        }
        if (min.getContent() != null && !min.getContent().equals("")) {
            minline.append('>');
            if (min.getBelow() != "") {
                minline.append("\n<!-- ").append(min.getBelow()).append(commentend);
            }
            minline.append(min.getContent());
            dataBuffWriter.write(minline.toString());
            dataBuffWriter.write(minend);
        } else {
            minline.append("/>");
            if (min.getBelow() != "") {
                minline.append("\n<!-- ").append(min.getBelow()).append(commentend);
            }
            dataBuffWriter.write(minline.toString());
        }
    }

    public void writeMax(SavotMax max) throws IOException {
        StringBuffer maxline = new StringBuffer();
        if (max.getAbove() != "") {
            maxline.append("\n<!-- ").append(max.getAbove()).append(" -->");
        }
        maxline.append("\n<MAX");
        if (max.getValue() != null && !max.getValue().equals("")) {
            maxline.append(" value=").append('\"').append(SavotWriter.encodeAttribute(max.getValue())).append('\"');
        }
        if (max.getInclusive() != null && !max.getInclusive().equals("")) {
            maxline.append(" inclusive=").append('\"').append(SavotWriter.encodeAttribute(max.getInclusive())).append('\"');
        }
        if (max.getContent() != null && !max.getContent().equals("")) {
            maxline.append('>');
            if (max.getBelow() != "") {
                maxline.append("\n<!-- ").append(max.getBelow()).append(commentend);
            }
            maxline.append(max.getContent());
            dataBuffWriter.write(maxline.toString());
            dataBuffWriter.write(maxend);
        } else {
            maxline.append("/>");
            if (max.getBelow() != "") {
                maxline.append("\n<!-- ").append(max.getBelow()).append(commentend);
            }
            dataBuffWriter.write(maxline.toString());
        }
    }

    public void writeOption(OptionSet optionSet) throws IOException {
        int m = 0;
        while (m < optionSet.getItemCount()) {
            StringBuffer optionline = new StringBuffer();
            SavotOption option = (SavotOption)optionSet.getItemAt(m);
            if (option.getAbove() != "") {
                optionline.append("\n<!-- ").append(option.getAbove()).append(" -->");
            }
            optionline.append("\n<OPTION");
            if (option.getName() != null && !option.getName().equals("")) {
                optionline.append(" name=").append('\"').append(SavotWriter.encodeAttribute(option.getName())).append('\"');
            }
            if (option.getValue() != null && !option.getValue().equals("")) {
                optionline.append(" value=").append('\"').append(SavotWriter.encodeAttribute(option.getValue())).append('\"');
            }
            if (option.getOptions().getItemCount() != 0) {
                optionline.append('>');
                if (option.getBelow() != "") {
                    optionline.append("\n<!-- ").append(option.getBelow()).append(commentend);
                }
                OptionSet options = option.getOptions();
                dataBuffWriter.write(optionline.toString());
                this.writeOption(options);
                dataBuffWriter.write(optionend);
            } else {
                optionline.append("/>");
                if (option.getBelow() != "") {
                    optionline.append("\n<!-- ").append(option.getBelow()).append(commentend);
                }
                dataBuffWriter.write(optionline.toString());
            }
            ++m;
        }
    }

    public void writeGroup(GroupSet groupSet) throws IOException {
        int m = 0;
        while (m < groupSet.getItemCount()) {
            ParamSet groups;
            StringBuffer groupline = new StringBuffer();
            SavotGroup group = (SavotGroup)groupSet.getItemAt(m);
            if (group.getAbove() != "") {
                groupline.append("\n<!-- ").append(group.getAbove()).append(" -->");
            }
            groupline.append("\n<GROUP");
            if (group.getId() != null && !group.getId().equals("")) {
                groupline.append(" ID=").append('\"').append(SavotWriter.encodeAttribute(group.getId())).append('\"');
            }
            if (group.getName() != null && !group.getName().equals("")) {
                groupline.append(" name=").append('\"').append(SavotWriter.encodeAttribute(group.getName())).append('\"');
            }
            if (group.getRef() != null && !group.getRef().equals("")) {
                groupline.append(" ref=").append('\"').append(SavotWriter.encodeAttribute(group.getRef())).append('\"');
            }
            if (group.getUcd() != null && !group.getUcd().equals("")) {
                groupline.append(" ucd=").append('\"').append(SavotWriter.encodeAttribute(group.getUcd())).append('\"');
            }
            if (group.getUtype() != null && !group.getUtype().equals("")) {
                groupline.append(" utype=").append('\"').append(SavotWriter.encodeAttribute(group.getUtype())).append('\"');
            }
            groupline.append('>');
            if (group.getBelow() != "") {
                groupline.append("\n<!-- ").append(group.getBelow()).append(commentend);
            }
            if (group.getDescription() != null && !group.getDescription().equals("")) {
                if (group.getAbove() != "") {
                    groupline.append("\n<!-- ").append(group.getAbove()).append(" -->");
                }
                groupline.append(descriptionbegin);
                if (group.getBelow() != "") {
                    groupline.append("\n<!-- ").append(group.getBelow()).append(commentend);
                }
                groupline.append(SavotWriter.encodeElement(group.getDescription())).append(descriptionend);
            }
            dataBuffWriter.write(groupline.toString());
            if (group.getFieldsRef().getItemCount() != 0) {
                FieldRefSet reffields = group.getFieldsRef();
                this.writeFieldRef(reffields);
            }
            if (group.getParamsRef().getItemCount() != 0) {
                ParamRefSet refgroups = group.getParamsRef();
                this.writeParamRef(refgroups);
            }
            if (group.getParams().getItemCount() != 0) {
                groups = group.getParams();
                this.writeParam(groups);
            }
            if (group.getGroups().getItemCount() != 0) {
                groups = group.getGroups();
                this.writeGroup((GroupSet)groups);
            }
            dataBuffWriter.write(groupend);
            ++m;
        }
    }

    public void writeTableBegin(SavotTable table) throws IOException {
        StringBuffer tableline = new StringBuffer();
        tableline.append("\n<TABLE");
        if (table.getId() != null && !table.getId().equals("")) {
            tableline.append(" ID=").append('\"').append(SavotWriter.encodeAttribute(table.getId())).append('\"');
        }
        if (table.getName() != null && !table.getName().equals("")) {
            tableline.append(" name=").append('\"').append(SavotWriter.encodeAttribute(table.getName())).append('\"');
        }
        if (table.getRef() != null && !table.getRef().equals("")) {
            tableline.append(" ref=").append('\"').append(SavotWriter.encodeAttribute(table.getRef())).append('\"');
        }
        if (table.getUcd() != null && !table.getUcd().equals("")) {
            tableline.append(" ucd=").append('\"').append(SavotWriter.encodeAttribute(table.getUcd())).append('\"');
        }
        if (table.getUtype() != null && !table.getUtype().equals("")) {
            tableline.append(" utype=").append('\"').append(SavotWriter.encodeAttribute(table.getUtype())).append('\"');
        }
        if (table.getNrows() != null && !table.getNrows().equals("")) {
            tableline.append(" nrows=").append('\"').append(SavotWriter.encodeAttribute(table.getNrows())).append('\"');
        }
        tableline.append('>');
        dataBuffWriter.write(tableline.toString());
        if (table.getDescription() != null && !table.getDescription().equals("")) {
            this.writeDescription(table.getDescription());
        }
    }

    public void writeTableEnd() throws IOException {
        dataBuffWriter.write(tableend);
    }

    public void writeResourceBegin(SavotResource resource) throws IOException {
        StringBuffer line = new StringBuffer();
        line.append("\n<RESOURCE");
        if (!resource.getName().equals("")) {
            line.append(" name=\"").append(SavotWriter.encodeAttribute(resource.getName())).append('\"');
        }
        if (!resource.getId().equals("")) {
            line.append(" ID=\"").append(SavotWriter.encodeAttribute(resource.getId())).append('\"');
        }
        if (!resource.getUtype().equals("")) {
            line.append(" utype=\"").append(SavotWriter.encodeAttribute(resource.getUtype())).append('\"');
        }
        if (!resource.getType().equals("")) {
            line.append(" type=\"").append(SavotWriter.encodeAttribute(resource.getType())).append('\"');
        }
        line.append('>');
        dataBuffWriter.write(line.toString());
    }

    public void writeResourceEnd() throws IOException {
        dataBuffWriter.write(resourceend);
    }

    public void writeTableDataBegin() throws IOException {
        dataBuffWriter.write(tabledatabegin);
    }

    public void writeTableDataEnd() throws IOException {
        dataBuffWriter.write("\n");
        dataBuffWriter.write(tabledataend);
    }

    public void writeDataBegin() throws IOException {
        dataBuffWriter.write(databegin);
    }

    public void writeDataEnd() throws IOException {
        dataBuffWriter.write("\n");
        dataBuffWriter.write(dataend);
    }

    public void writeTR(SavotTR tr) throws IOException {
        StringBuffer trline = new StringBuffer();
        TDSet tds = tr.getTDSet();
        trline.append(trbegin);
        int r = 0;
        while (r < tds.getItemCount()) {
            trline.append(tdbegin1);
            if (((SavotTD)tds.getItemAt(r)).getEncoding() != null && !((SavotTD)tds.getItemAt(r)).getEncoding().equals("")) {
                trline.append(" encoding=\"").append(((SavotTD)tds.getItemAt(r)).getEncoding()).append('\"');
            }
            trline.append(tdbegin2);
            if (elementEntities) {
                trline.append(SavotWriter.encodeElement(tds.getContent(r)));
            } else {
                trline.append(tds.getContent(r));
            }
            trline.append(tdend);
            ++r;
        }
        trline.append(trend);
        dataBuffWriter.write(trline.toString());
    }

    public void writeResource(ResourceSet resourceset) throws IOException {
        if (resourceset != null) {
            int resourcecount = resourceset.getItemCount();
            int i = 0;
            while (i < resourcecount) {
                StringBuffer resource = new StringBuffer();
                if (((SavotResource)resourceset.getItemAt(i)).getAbove() != "") {
                    resource.append("\n<!-- ").append(((SavotResource)resourceset.getItemAt(i)).getAbove()).append(" -->");
                }
                resource.append("\n<RESOURCE");
                if (!((SavotResource)resourceset.getItemAt(i)).getName().equals("")) {
                    resource.append(" name=").append('\"').append(SavotWriter.encodeAttribute(((SavotResource)resourceset.getItemAt(i)).getName())).append('\"');
                }
                if (!((SavotResource)resourceset.getItemAt(i)).getId().equals("")) {
                    resource.append(" ID=").append('\"').append(SavotWriter.encodeAttribute(((SavotResource)resourceset.getItemAt(i)).getId())).append('\"');
                }
                if (!((SavotResource)resourceset.getItemAt(i)).getUtype().equals("")) {
                    resource.append(" utype=").append('\"').append(SavotWriter.encodeAttribute(((SavotResource)resourceset.getItemAt(i)).getUtype())).append('\"');
                }
                if (!((SavotResource)resourceset.getItemAt(i)).getType().equals("")) {
                    resource.append(" type=").append('\"').append(SavotWriter.encodeAttribute(((SavotResource)resourceset.getItemAt(i)).getType())).append('\"');
                }
                resource.append('>');
                if (((SavotResource)resourceset.getItemAt(i)).getBelow() != "") {
                    resource.append("\n<!-- ").append(((SavotResource)resourceset.getItemAt(i)).getBelow()).append(commentend);
                }
                dataBuffWriter.write(resource.toString());
                if (!((SavotResource)resourceset.getItemAt(i)).getDescription().equals("")) {
                    StringBuffer description = new StringBuffer();
                    description.append(descriptionbegin).append(SavotWriter.encodeElement(((SavotResource)resourceset.getItemAt(i)).getDescription())).append(descriptionend);
                    dataBuffWriter.write(description.toString());
                }
                InfoSet infoset = ((SavotResource)resourceset.getItemAt(i)).getInfos();
                this.writeInfo(infoset);
                CoosysSet coosysSet = ((SavotResource)resourceset.getItemAt(i)).getCoosys();
                this.writeCoosys(coosysSet);
                ParamSet params = ((SavotResource)resourceset.getItemAt(i)).getParams();
                this.writeParam(params);
                LinkSet linkSet = ((SavotResource)resourceset.getItemAt(i)).getLinks();
                this.writeLink(linkSet);
                TableSet tableSet = ((SavotResource)resourceset.getItemAt(i)).getTables();
                StringBuffer tableline = new StringBuffer();
                int k = 0;
                while (k < tableSet.getItemCount()) {
                    SavotTable table = (SavotTable)tableSet.getItemAt(k);
                    tableline.delete(0, tableline.length());
                    if (table.getAbove() != "") {
                        tableline.append("\n<!-- ").append(table.getAbove()).append(" -->");
                    }
                    tableline.append("\n<TABLE");
                    if (table.getId() != null && !table.getId().equals("")) {
                        tableline.append(" ID=").append('\"').append(SavotWriter.encodeAttribute(table.getId())).append('\"');
                    }
                    if (table.getName() != null && !table.getName().equals("")) {
                        tableline.append(" name=").append('\"').append(SavotWriter.encodeAttribute(table.getName())).append('\"');
                    }
                    if (table.getRef() != null && !table.getRef().equals("")) {
                        tableline.append(" ref=").append('\"').append(SavotWriter.encodeAttribute(table.getRef())).append('\"');
                    }
                    if (table.getUcd() != null && !table.getUcd().equals("")) {
                        tableline.append(" ucd=").append('\"').append(SavotWriter.encodeAttribute(table.getUcd())).append('\"');
                    }
                    if (table.getUtype() != null && !table.getUtype().equals("")) {
                        tableline.append(" utype=").append('\"').append(SavotWriter.encodeAttribute(table.getUtype())).append('\"');
                    }
                    if (table.getNrows() != null && !table.getNrows().equals("")) {
                        tableline.append(" nrows=").append('\"').append(SavotWriter.encodeAttribute(table.getNrows())).append('\"');
                    }
                    tableline.append('>');
                    if (table.getBelow() != "") {
                        tableline.append("\n<!-- ").append(table.getBelow()).append(commentend);
                    }
                    if (!table.getDescription().equals("")) {
                        String description = descriptionbegin + SavotWriter.encodeElement(table.getDescription()) + descriptionend;
                        tableline.append(description);
                    }
                    dataBuffWriter.write(tableline.toString());
                    FieldSet fieldSet = table.getFields();
                    this.writeField(fieldSet);
                    ParamSet paramSet = table.getParams();
                    this.writeParam(paramSet);
                    GroupSet groupSet = table.getGroups();
                    this.writeGroup(groupSet);
                    linkSet = table.getLinks();
                    this.writeLink(linkSet);
                    if (table.getData() != null) {
                        dataBuffWriter.write(databegin);
                        SavotData data = table.getData();
                        if (data.getTableData() != null) {
                            dataBuffWriter.write(tabledatabegin);
                            SavotTableData tableData = data.getTableData();
                            TRSet trs = tableData.getTRs();
                            StringBuffer rowbuffer = new StringBuffer(1000);
                            int p = 0;
                            while (p < trs.getItemCount()) {
                                TDSet tds = trs.getTDSet(p);
                                dataBuffWriter.write(trbegin);
                                rowbuffer.delete(0, rowbuffer.length());
                                int r = 0;
                                while (r < tds.getItemCount()) {
                                    if (((SavotTD)tds.getItemAt(r)).getAbove() != "") {
                                        rowbuffer.append("\n<!-- ").append(((SavotTD)tds.getItemAt(r)).getAbove()).append(commentend);
                                    }
                                    rowbuffer.append(tdbegin1);
                                    if (((SavotTD)tds.getItemAt(r)).getEncoding() != null && !((SavotTD)tds.getItemAt(r)).getEncoding().equals("")) {
                                        rowbuffer.append(" encoding=\"").append(((SavotTD)tds.getItemAt(r)).getEncoding()).append('\"');
                                    }
                                    rowbuffer.append(tdbegin2);
                                    if (((SavotTD)tds.getItemAt(r)).getBelow() != "") {
                                        rowbuffer.append("\n<!-- ").append(((SavotTD)tds.getItemAt(r)).getBelow()).append(commentend);
                                    }
                                    if (elementEntities) {
                                        rowbuffer.append(SavotWriter.encodeElement(tds.getContent(r)));
                                    } else {
                                        rowbuffer.append(tds.getContent(r));
                                    }
                                    rowbuffer.append(tdend);
                                    ++r;
                                }
                                dataBuffWriter.write(rowbuffer.toString());
                                dataBuffWriter.write(trend);
                                ++p;
                            }
                            dataBuffWriter.write(tabledataend);
                        }
                        if (data.getBinary() != null) {
                            this.writeBinary(data.getBinary());
                        }
                        if (data.getFits() != null) {
                            this.writeFits(data.getFits());
                        }
                        dataBuffWriter.write(dataend);
                    }
                    dataBuffWriter.write(tableend);
                    ++k;
                }
                if (((SavotResource)resourceset.getItemAt(i)).getResources().getItemCount() != 0) {
                    this.writeResource(((SavotResource)resourceset.getItemAt(i)).getResources());
                }
                dataBuffWriter.write(resourceend);
                ++i;
            }
        }
    }
}

